package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.ExamXpertData;
import org.msh.tb.entities.ExamXpert;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.XpertResult;
import org.msh.tb.entities.enums.XpertRifResult;

/**
 * Created by rmemoria on 13/9/17.
 */
public class ExamXpertConsumer extends SyncDataConsumerImpl<ExamXpertData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamXpertData data) {
        ExamXpert exam = recoverEntity(ExamXpert.class, data.getServerId());

        moveLaboratoryExamData(data, exam);

        updateResult(exam, data.getResult());
        exam.setSampleNumber(data.getSampleNumber());
        exam.setLaboratory(getLaboratory(data.getLaboratoryId()));
        exam.setDateRelease(data.getDateRelease());
        exam.setComments(data.getComments());

        getEntityManager().persist(exam);

        return data.getServerId() == null ? exam.getId() : null;
    }

    private void updateResult(ExamXpert exam, ExamXpertData.Result res) {
        exam.setResult(null);
        exam.setRifResult(null);

        switch (res) {
            case INVALID_NORESULT_ERROR:
                exam.setResult(XpertResult.INVALID_NORESULT_ERROR);
                break;
            case TB_DETECTED_RR_DETECTED:
                exam.setResult(XpertResult.TB_DETECTED);
                exam.setRifResult(XpertRifResult.RIF_DETECTED);
                break;
            case TB_DETECTED_RR_INDETERMINATE:
                exam.setResult(XpertResult.TB_DETECTED);
                exam.setRifResult(XpertRifResult.RIF_INDETERMINATE);
                break;
            case TB_DETECTED_RR_NOT_DETECTED:
                exam.setResult(XpertResult.TB_DETECTED);
                exam.setRifResult(XpertRifResult.RIF_NOT_DETECTED);
                break;
            case TB_NOT_DETECTED:
                exam.setResult(XpertResult.TB_NOT_DETECTED);
                break;
        }
    }
}
